#include "graydecode.h"

int bw_color_offset = 0;

void FastAveragingDecoder::decodeFrame(unsigned char *membase, int offset, bool invert_polarity)
{
   int v;
   register int lp_filter;
   int last_lp_filter;
   RGBTRIPLE pixels[360];

   membase += offset + getColorBurstWidth();

	lockDisplay();

	for (int y=0; y < 280; y++)
	{
     	unsigned char* ptr1 = membase;

   	for (int x = 0; x < 360; x++)
		{
         lp_filter = *ptr1++;
         lp_filter += *ptr1++;
         lp_filter += *ptr1++;
         lp_filter += *ptr1++;
         lp_filter += *ptr1++;

         if (x == 0)
         	v = (lp_filter) >> 1;
         else
	         v = (last_lp_filter+lp_filter) >> 2;

         last_lp_filter = lp_filter;

   	   v += 60 + bw_color_offset;

	      if (invert_polarity)
	        	v = 255 - v;
	      if (v > 250)
	   	  	v = 250;
      	else if (v < 0)
           	v = 0;

			pixels[x].rgbtRed = pixels[x].rgbtGreen = pixels[x].rgbtBlue = v;
		}

      drawPixels(0, y, pixels, 370);

      membase += 2268;
   }

	unlockDisplay();
}


void AveragingDecoder::decodeFrame(unsigned char *membase, int offset, bool invert_polarity)
{
	int v;
	register int lp_filter;
	int last_lp_filter;
	RGBTRIPLE pixels[720];

	membase += offset + getColorBurstWidth();

	lockDisplay();

	for (int y=0; y < 240; y++)
	{
   		for (int x = 0; x < 720; x++)
		{
			unsigned char* ptr1 = membase + (x * 1800)/720;
			lp_filter = *ptr1++;
			lp_filter += *ptr1++;
			lp_filter += *ptr1++;
			lp_filter += *ptr1++;
			lp_filter += *ptr1++;

			if (x == 0)
         		v = (lp_filter) >> 1;
			else
				v = (last_lp_filter+lp_filter) >> 2;
			last_lp_filter = lp_filter;

   			v += 60 + bw_color_offset;

			if (invert_polarity)
				v = 255 - v;
			if (v > 250)
	   	  		v = 250;
      		else if (v < 0)
           		v = 0;

			pixels[x].rgbtRed = pixels[x].rgbtGreen = pixels[x].rgbtBlue = v;
		}

		drawPixels(0, y*2, pixels, 720);
		drawPixels(0, y*2+1, pixels, 720);

		membase += 2268;
	}

	unlockDisplay();
}
